package parametricTypes;

public class ParametricExample {
	  
	// a parametric product type
	static class Prod<A,B> {
		A pi1;
		B pi2;
		Prod(A a, B b) {
			this.pi1 = a;
			this.pi2 = b;
		}
	}
	  
	// a close-enough parametric sum type
	// (see SumExample for why this is not a real sum)
	interface Sum<A,B> {}
	static class In1<A,B> implements Sum<A,B> {
		A a;
		In1(A a) {
			this.a = a;
		}
	}
	static class In2<A,B> implements Sum<A,B> {
		B b;
		In2(B b) {
			this.b = b;
		}
	}
	  
	// a parametric function type
	interface Fun<A,B> {
		B fun(A a);
	}
	  
	public static void main(String[] args) {
	    //===============================================================
	    // product
	    
	    // introduction
	    Prod<Integer, String> p = new Prod<Integer, String>(3, "shrdlu");
	    // here the type after the new is automatically inferred to be Prod<Character, Boolean<
	    Prod<Character, Boolean> q = new Prod<>('a', true);
	    // elimination
	    System.out.println("p.pi1 = " + p.pi1 + ", p.pi2 = " + p.pi2);
	    System.out.println("q.pi1 = " + q.pi1 + ", q.pi2 = " + q.pi2);
	    
	    System.out.println("===========================");
	    
	    //===============================================================
	    // sum
	    
	    // introduction
	    Sum<Integer, String> r = new In1<Integer, String>(4);
	    Sum<Character, Boolean> s = new In2<>(true);
	    // elimination
	    if (r instanceof In1) {
			In1<Integer, String> o = (In1<Integer, String>) r;
			System.out.println("In1: " + o.a);
		} else if (r instanceof In2) {
			In2<Integer, String> o = (In2<Integer, String>) r;
			System.out.println("In2: " + o.b);
		}
	    
	    if (s instanceof In1) {
			In1<Character, Boolean> o = (In1<Character, Boolean>) s;
			System.out.println("In1: " + o.a);
		} else if (s instanceof In2) {
			In2<Character, Boolean> o = (In2<Character, Boolean>) s;
			System.out.println("In2: " + o.b);
		}

	    //===============================================================
	    // function
	    
	    // introduction
	    Fun<Integer, String> f = i -> "output = " + i;
	    // elimination
	    System.out.println(f.fun(42));
	}
	
}
